/* ============ */
/* freqdefs.h	*/
/* ============ */
# if defined(__FREQDEFS_H)
#	/* Do Nothing */
# else
#	define	__FREQDEFS_H
/* ==================================================================== */
/*      D E F I N I T I O N S  F O R  P R O G R A M  F R E Q T S T	*/
/* ==================================================================== */

#define	MAX_ELEMS	32768           /* Chi-Square */
#define	MIN_ELEMS	64              /* Chi-Square */
#define	MAX_EXPECT	100             /* Chi-Square */
#define	MIN_EXPECT	5               /* Chi-Square */
#define	MIN_KS_SAMPS	100  		/* Kolmogorov-Smirnov */
#define	MAX_KS_SAMPS	10000		/* Kolmogorov-Smirnov */
#define	MIN_KS_RUNS	20  		/* Kolmogorov-Smirnov */
#define	MAX_KS_RUNS	100		/* Kolmogorov-Smirnov */

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

typedef	struct	ChiSqStru
    {
	UINT	NumElements;		/* No. Elements in Sample Space	*/
	int	CellExpect;		/* Number of Samples Per Cell	*/
	ULONG   NumVariates;		/* No. Variates to be Generated	*/
	long	TotNumGen;		/* Progressive Variate Count	*/
	double	ChiSqValu;		/* Result of Chi-Square Test	*/
	int     (*RandFun) F((void));	/* Address of Generator		*/
    }
	CHISQ_STRU;

typedef	struct	KSDataStru
    {
	UINT	SampleSize;		/* No. Samples Per Run		*/
	int	NumKSRuns;		/* No. Runs for KS-on-KS	*/
	long	TotNumGen;		/* Progressive Variate Count	*/
	double	KnPlus;			/* Statistic for Kn+		*/
	double	KnMinus;		/* Statistic for Kn-		*/
	double	KnPlusProb;		/* Probability for Kn+ 		*/
	double	KnMinusProb;		/* Probability for Kn-		*/
	int     (*RandFun) F((void));	/* Address of Generator		*/
    }
	KS_DATA_STRU;

/* INDENT OFF */
extern	void	ChiSqFreq	 F((CHISQ_STRU *));
extern	void	ChiSqRan	 F((CHISQ_STRU *));
extern	void	ExecChiSqTest	 F((CHISQ_STRU *));
extern	void	ExecKolSmirTest  F((KS_DATA_STRU *));
extern	void	KSFreq		 F((KS_DATA_STRU *));
extern	void	SetChiSqControls F((CHISQ_STRU *));
extern	void	SetKoSmControls  F((KS_DATA_STRU *));

# undef F
/* INDENT ON */

# endif				/* << __FREQDEFS_H >> */
